# Advanced Pac Screen 1.1 – Demo Programs

This archive contains the example programs from the Advanced Pac Screen 1.1 manual. Some programs differ slightly from the version printed in the manual due to minor bugs I've found while trying them out.

Please note that the program listings for the HP-41 use the common notation `>"SomeText"` for appending text.

![Advanced Pac Screen 1.1 Welcome Screen](./images/aps-welcome.gif)

## LIF Image

The LIF image `./bin/aps1demo.dat` contains all programs described below. Note that the HP-71/HP-75 programs are stored as text files. After loading the text file from the image, you have have to convert them into a Basic file, using a command like:

`TRANSFORM "NAME" INTO BASIC` 

## PLOTSIN (HP-41)

### Usage
1. Select the APS plotter device: `"PAC-PLOT" FINDID SELECT`
2. Run the program.

### Output

![PLOTSIN Output](./images/plotsin.gif)

### Program Listing

See: [PLOTSIN Listing](src/aps1-hp41-plotsin.txt?raw=true).

## BALKEN (HP-41)

### Usage
1. Select the APS plotter device:
   `"PAC-PLOT" FINDID SELECT`
2. Run the program.

## Output

![BALKEN Output](./images/balken.gif)

### Program Listing

See [BALKEN Listing](./src/aps1-hp41-balken.txt?raw=true).

## TROPFEN (HP-71, HP-75)

### Usage
1. Set printer to PAC-PLOT device:
   - HP-71:` PRINTER IS GRAPHIC`
   - HP-75:
     - Run `ASSIGN IO` and assign PAC-PLOT to `:PL:`
     - `PRINTER IS ':PL'`

### Output

![TROPFEN Output](./images/tropfen.gif)

### Program Listing

See [TROPFEN Listing](./src/aps1-hp7x-tropfen.txt?raw=true).

## UHR (HP-71)

Although, the manual states that it works for both, the HP-71 _and_ the HP-75, this is not true due to the `GOTO` and `GOSUB`commands using labels instead of line number which is not supported by the HP-75. However, porting it to the HP-75 should be easy, but I didn't do it.

### Usage
1. Set printer to PAC-PLOT device: `PRINTER IS GRAPHIC`

### Output

![UHR Output](./images/uhr.gif)

### Program Listing

See [UHR Listing](./src/aps1-hp71-uhr.txt?raw=true).
