#!/bin/sh

SRCDIR=./src
LIFFILE=./bin/aps1demo.dat

rm $LIFFILE
lifinit -m hdrive1 $LIFFILE 96 >temp.txt
liflabel $LIFFILE APS1D >temp.txt

comp41 -l -x hpil $SRCDIR/aps1-hp41-plotsin.txt | raw41lif PLOTSIN | lifput $LIFFILE
comp41 -l -x hpil $SRCDIR/aps1-hp41-balken.txt | raw41lif BALKEN | lifput $LIFFILE

textlif LISSAJ $SRCDIR/aps1-hp7x-lissajous.txt | lifput $LIFFILE
textlif STERNE $SRCDIR/aps1-hp7x-sterne.txt | lifput $LIFFILE
textlif UHR $SRCDIR/aps1-hp71-uhr.txt | lifput $LIFFILE
textlif TROPFEN $SRCDIR/aps1-hp7x-tropfen.txt | lifput $LIFFILE

textlif75 -n LISSAJ75 $SRCDIR/aps1-hp7x-lissajous.txt | lifput $LIFFILE
textlif75 -n STERNE75 $SRCDIR/aps1-hp7x-sterne.txt | lifput $LIFFILE
textlif75 -n TROPF75 $SRCDIR/aps1-hp7x-tropfen.txt | lifput $LIFFILE
# textlif75 -n GRHC $SRCDIR/aps1-hp75-grhc.txt | lifput $LIFFILE

lifdir $LIFFILE
rm temp.txt
